#include <iostream>
#include <algorithm>
#include <cmath>

using namespace std;

struct Jarbol {
    long long x;
    long long h;
    int indeks;
};

Jarbol jarboli[1000000];
long long rezultat[1000000];
int najbliziLevo[1000000];
int najbliziDesno[1000000];

int main() {
    int n;
    cin >> n;

    for (int i = 0; i < n; i++) {
        cin >> jarboli[i].x;
        jarboli[i].indeks = i;
    }

    for (int i = 0; i < n; i++) {
        cin >> jarboli[i].h;
        rezultat[i] = -1;
    }

    sort(jarboli, jarboli + n, [](Jarbol a, Jarbol b) {
        return a.x < b.x;
        });

    for (int i = 0; i < n; i++) {
        int j = i - 1;
        while (j >= 0 && jarboli[j].h < jarboli[i].h)
            j = najbliziLevo[j];
        najbliziLevo[i] = j;
    }

    for (int i = n - 1; i >= 0; i--) {
        int j = i + 1;
        while (j < n && jarboli[j].h < jarboli[i].h)
            j = najbliziDesno[j];
        najbliziDesno[i] = j;
    }

    for (int i = 0; i < n; i++) {
        long long najbolji = -1;

        if (najbliziLevo[i] != -1) {
            long long razlika = jarboli[najbliziLevo[i]].h - jarboli[i].h;
            najbolji = razlika;
        }

        if (najbliziDesno[i] != n) {
            long long razlika = jarboli[najbliziDesno[i]].h - jarboli[i].h;
            if (najbolji == -1 || razlika < najbolji)
                najbolji = razlika;
        }

        rezultat[jarboli[i].indeks] = najbolji;
    }

    for (int i = 0; i < n; i++) {
        cout << rezultat[i] << '\n';
    }

    return 0;
}